#ifndef XO_H_INCLUDED
#define XO_H_INCLUDED

#define XO_FILE_LOCK_ID      0xBF3EA126
#define XO_FILE_LOCK_SEED    0x01234567

#define DEBUG_LOG_FILENAME "xo.log"

extern DWORD _stdcall ShowFailMessage(CWnd* pwnd, char *errmsg, char *cause, UINT icon);

//-----------------------------------------
//    XO header;
//-----------------------------------------
typedef struct xoFileHeader
{
  DWORD       m_dwID;             //check whether it's 0x4A424F58 (XOBJ)
  long        m_Unk1;             //-1
  long        m_Unk2;             //-1
  float       m_fUnks[4];         // ?

  long        m_numFaces;
  long        m_FacesStart;       //always sizeof(xoFileHeader)
  long        m_FacesBlockSize;

  long        m_numVerts;
  long        m_VertsStart;
  long        m_VertsBlockSize;

  long        m_numNorms;
  long        m_NormsStart;
  long        m_NormsBlockSize;

  long        m_numTex;
  long        m_TexStart;
  long        m_TexBlockSize;
  xoFileHeader()
  {
    memset(this, 0, sizeof(*this));
    m_dwID = 0x4A424F58;
    m_Unk1 = m_Unk2 = -1;
  }
}xoFileHeader;


#define XO_FACE_SOLID       0x00000001
#define XO_FACE_SEMITRANS   0x00010000
#define XO_FACE_CHROME      0x00020000

//-----------------------------------------
//    XO faces;
//-----------------------------------------
typedef struct xoUVs
{
  float u1, v1,
        u2, v2,
        u3, v3;
}xoUVs;

typedef struct xoFace
{
  DWORD zero;           //always 0
  float fx, fy, fz;     //face normal
  float unk[2];         //?
  long  i1, i2, i3;     //vertices
  long  n1, n2, n3;     //normals
  
  long  One;            //always 1.
  DWORD someTrash;      //can set to 0x00000000 :)
  DWORD nFlags;
  long  zeros[2];       //always 0, 0

  DWORD m_VertColor[3]; //?
  long  m_nTexture;     //0 - untextured; 1-first texture, 2-second, etc.
  xoUVs m_UVs;
  xoFace()
  {
    memset(this, 0, sizeof(*this));
    One = 1;
  }
}xoFace; //0x6C


#endif /* XO_H_INCLUDED */


